/*
 * Decompiled with CFR 0.152.
 */
package benutzer;

import benutzer.SchuelerData;
import benutzerupdate.BenutzerUpdateController;
import dbUtil.dbConnection;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Slider;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.util.Callback;

public class BenutzerController
implements Initializable {
    @FXML
    private TextField svorname;
    @FXML
    private TextField snachname;
    @FXML
    private Slider sgeschlecht;
    @FXML
    private TextField sklasse;
    @FXML
    private Slider sleistung;
    @FXML
    private TextField sjahrgang;
    @FXML
    private TextField ssearch;
    @FXML
    private TableView<SchuelerData> stable;
    @FXML
    private TableColumn<SchuelerData, String> stableid;
    @FXML
    private TableColumn<SchuelerData, String> stablevorname;
    @FXML
    private TableColumn<SchuelerData, String> stablenachname;
    @FXML
    private TableColumn<SchuelerData, String> stablegeschlecht;
    @FXML
    private TableColumn<SchuelerData, String> stableleistung;
    @FXML
    private TableColumn<SchuelerData, String> stableklasse;
    @FXML
    private TableColumn<SchuelerData, String> stablejahrgang;
    @FXML
    private ComboBox<String> kklassecb;
    @FXML
    private ComboBox<String> kjahrgangcb;
    @FXML
    private Label ksanzahl;
    @FXML
    private TextField ksearch;
    @FXML
    private TableView<SchuelerData> ktable;
    @FXML
    private TableColumn<SchuelerData, String> ktablevorname;
    @FXML
    private TableColumn<SchuelerData, String> ktablenachname;
    @FXML
    private TableColumn<SchuelerData, String> ktablegeschlecht;
    @FXML
    private TableColumn<SchuelerData, String> ktableleistung;
    @FXML
    private TableColumn<SchuelerData, String> ktablejahrgang;
    @FXML
    private CheckBox ggeschlecht;
    @FXML
    private CheckBox gleistung;
    @FXML
    private TextField ggroesse;
    @FXML
    private ComboBox<String> gklasse;
    @FXML
    private ComboBox<String> gjahrgang;
    @FXML
    private TextArea gtextarea;
    @FXML
    private TextArea gtextarea2;
    private dbConnection dc;
    private ObservableList<SchuelerData> data;
    private ObservableList<SchuelerData> klassendata;

    public void initialize(URL url, ResourceBundle rb) {
        this.dc = new dbConnection();
        this.stable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.ktable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.stablejahrgang.setSortType(TableColumn.SortType.ASCENDING);
    }

    @FXML
    private void removeRowStable(ActionEvent event) {
        this.removeRow(this.stable);
    }

    @FXML
    private void removeRowKtable(ActionEvent event) {
        this.removeRow(this.ktable);
    }

    private void removeRow(TableView<SchuelerData> selTable) {
        ObservableList selectedRows = selTable.getSelectionModel().getSelectedItems();
        ArrayList<SchuelerData> rows = new ArrayList<SchuelerData>((Collection<SchuelerData>)selectedRows);
        ArrayList eintraege = new ArrayList();
        rows.forEach(row -> {
            boolean bl = eintraege.add(String.valueOf(row.getsVorname()) + " " + row.getsNachname());
        });
        String confString = "M\u00f6chtest du wirklich die Sch\u00fcler";
        int i = 0;
        while (i < eintraege.size()) {
            if (eintraege.size() == 1) {
                confString = "M\u00f6chtest du wirklich den Sch\u00fcler " + (String)eintraege.get(i) + " l\u00f6schen?";
            } else if (i == eintraege.size()) {
                confString = String.valueOf(confString) + " l\u00f6schen?";
            } else if (eintraege.size() > 1) {
                confString = i == eintraege.size() ? String.valueOf(confString) + " l\u00f6schen?" : (i == eintraege.size() - 1 ? String.valueOf(confString) + " und " + (String)eintraege.get(i) + " l\u00f6schen?" : (i == 0 ? String.valueOf(confString) + " " + (String)eintraege.get(i) : String.valueOf(confString) + ", " + (String)eintraege.get(i)));
            }
            ++i;
        }
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, confString, new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL});
        alert.showAndWait();
        if (alert.getResult() != ButtonType.YES) {
            System.out.println("Nein");
            return;
        }
        System.out.println("JA");
        rows.forEach(row -> this.removeRowFromId(row.getsID()));
    }

    private void removeRowFromId(String rowid) {
        String sqlRemove = "DELETE FROM schueler WHERE id = ?";
        System.out.println(sqlRemove);
        try {
            Connection rconn = dbConnection.getConnection();
            PreparedStatement rstmt = rconn.prepareStatement(sqlRemove);
            rstmt.setString(1, rowid);
            rstmt.execute();
            rstmt.close();
            this.loadSchuelerData();
            this.getGruppenSelects();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void filterKTable() {
        FilteredList fdata = new FilteredList(this.klassendata, p -> true);
        fdata.setPredicate(p -> {
            if (this.ksearch.getText() == null || this.ksearch.getText().isEmpty()) {
                return true;
            }
            String lowerCaseFilter = this.ksearch.getText().toLowerCase();
            if (p.getsVorname().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return p.getsNachname().toLowerCase().contains(lowerCaseFilter);
        });
        this.ktable.setItems((ObservableList)fdata);
    }

    @FXML
    private void filterSTable() {
        FilteredList fdata = new FilteredList(this.data, p -> true);
        fdata.setPredicate(p -> {
            if (this.ssearch.getText() == null || this.ssearch.getText().isEmpty()) {
                return true;
            }
            String lowerCaseFilter = this.ssearch.getText().toLowerCase();
            if (p.getsVorname().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return p.getsNachname().toLowerCase().contains(lowerCaseFilter);
        });
        this.stable.setItems((ObservableList)fdata);
    }

    @FXML
    private void loadSchuelerDataAction(ActionEvent event) throws SQLException {
        this.loadSchuelerData();
    }

    @FXML
    public void loadSchuelerData() throws SQLException {
        String sql = "SELECT * FROM schueler";
        try {
            Connection conn = dbConnection.getConnection();
            this.data = FXCollections.observableArrayList();
            ResultSet rs = conn.createStatement().executeQuery(sql);
            while (rs.next()) {
                this.data.add((Object)new SchuelerData(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7)));
            }
        }
        catch (SQLException e) {
            System.err.println("Error: " + e);
        }
        this.stableid.setCellValueFactory((Callback)new PropertyValueFactory("sID"));
        this.stablevorname.setCellValueFactory((Callback)new PropertyValueFactory("sVorname"));
        this.stablenachname.setCellValueFactory((Callback)new PropertyValueFactory("sNachname"));
        this.stablegeschlecht.setCellValueFactory((Callback)new PropertyValueFactory("sGeschlecht"));
        this.stableleistung.setCellValueFactory((Callback)new PropertyValueFactory("sLeistung"));
        this.stableklasse.setCellValueFactory((Callback)new PropertyValueFactory("sKlasse"));
        this.stablejahrgang.setCellValueFactory((Callback)new PropertyValueFactory("sJahrgang"));
        this.stable.setItems(null);
        this.stable.setItems(this.data);
        this.filterSTable();
    }

    @FXML
    private void refreshKlassenDataAction(ActionEvent event) throws SQLException {
        this.refreshKlassenData();
    }

    @FXML
    public void refreshKlassenData() throws SQLException {
        String klasse = (String)this.kklassecb.getValue();
        String jahrgang = (String)this.kjahrgangcb.getValue();
        System.out.println("Klasse: " + klasse + "Jahrgang: " + jahrgang);
        String sqlk = "SELECT * FROM schueler WHERE klasse = '" + klasse + "' AND jahrgang = '" + jahrgang + "'";
        try {
            Connection kconn = dbConnection.getConnection();
            this.klassendata = FXCollections.observableArrayList();
            ResultSet rs = kconn.createStatement().executeQuery(sqlk);
            while (rs.next()) {
                this.klassendata.add((Object)new SchuelerData(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7)));
            }
        }
        catch (SQLException e) {
            System.err.println("Error: " + e);
        }
        this.ktablevorname.setCellValueFactory((Callback)new PropertyValueFactory("sVorname"));
        this.ktablenachname.setCellValueFactory((Callback)new PropertyValueFactory("sNachname"));
        this.ktablegeschlecht.setCellValueFactory((Callback)new PropertyValueFactory("sGeschlecht"));
        this.ktableleistung.setCellValueFactory((Callback)new PropertyValueFactory("sLeistung"));
        this.ktablejahrgang.setCellValueFactory((Callback)new PropertyValueFactory("sJahrgang"));
        this.ktable.setItems(null);
        this.ktable.setItems(this.klassendata);
        this.ksanzahl.setText(String.valueOf(this.ktable.getItems().size()));
    }

    @FXML
    private void addSchueler(ActionEvent event) {
        String sqlInsert = "INSERT INTO schueler(vorname,nachname,geschlecht,leistung,klasse,jahrgang) VALUES (?,?,?,?,?,?)";
        try {
            Connection conn = dbConnection.getConnection();
            PreparedStatement stmt = conn.prepareStatement(sqlInsert);
            stmt.setString(1, this.svorname.getText());
            stmt.setString(2, this.snachname.getText());
            String geschl = "M";
            geschl = (int)this.sgeschlecht.getValue() >= 5 ? "W" : "M";
            stmt.setString(3, geschl);
            stmt.setInt(4, (int)this.sleistung.getValue());
            stmt.setString(5, this.sklasse.getText().toUpperCase());
            stmt.setString(6, this.sjahrgang.getText());
            stmt.execute();
            stmt.close();
            System.out.println(this.svorname.getText());
            System.out.println(this.snachname.getText());
            System.out.println(geschl);
            System.out.println((int)this.sleistung.getValue());
            System.out.println(this.sklasse.getText());
            System.out.println(this.sjahrgang.getText());
            this.loadSchuelerData();
            this.clearForm();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void clearForm() {
        this.svorname.setText("");
        this.snachname.setText("");
        this.sgeschlecht.setValue(0.0);
        this.sleistung.setValue(10.0);
    }

    @FXML
    private void updateSrowPanel(ActionEvent event) {
        this.updateRows(this.stable);
    }

    @FXML
    private void updateKrowPanel(ActionEvent event) {
        this.updateRows(this.ktable);
    }

    private void updateRows(TableView<SchuelerData> selTable) {
        if (selTable.getSelectionModel().getSelectedItems().isEmpty()) {
            System.out.println("Keine Spalte/n ausgew\u00e4hlt.");
        } else {
            ObservableList selectedRows = selTable.getSelectionModel().getSelectedItems();
            ArrayList<SchuelerData> rows = new ArrayList<SchuelerData>((Collection<SchuelerData>)selectedRows);
            rows.forEach(row -> this.updateRowPanel(row.getsID(), row.getsVorname(), row.getsNachname(), row.getsGeschlecht(), row.getsKlasse(), Double.parseDouble(row.getsLeistung()), row.getsJahrgang()));
        }
    }

    private void updateRowPanel(String id, String vorname, String nachname, String geschlecht, String klasse, Double leistung, String jahrgang) {
        try {
            Stage updateStage = new Stage();
            FXMLLoader updateLoader = new FXMLLoader();
            Pane updateRoot = (Pane)updateLoader.load(this.getClass().getResource("/benutzerupdate/UpdateBenutzerRow.fxml").openStream());
            BenutzerUpdateController benutzerUpdateController = (BenutzerUpdateController)updateLoader.getController();
            Scene scene = new Scene((Parent)updateRoot);
            updateStage.setScene(scene);
            updateStage.setTitle("Eintrag Updaten");
            updateStage.show();
            benutzerUpdateController.id = id;
            benutzerUpdateController.vorname = vorname;
            benutzerUpdateController.nachname = nachname;
            benutzerUpdateController.geschlecht = geschlecht;
            benutzerUpdateController.klasse = klasse;
            benutzerUpdateController.leistung = leistung;
            benutzerUpdateController.jahrgang = jahrgang;
            benutzerUpdateController.setInputs();
            benutzerUpdateController.benutzerController = this;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @FXML
    private void getGruppenSelectsAction(ActionEvent event) throws SQLException {
        this.getGruppenSelects();
    }

    @FXML
    public void getGruppenSelects() {
        int i;
        Statement st;
        Connection gconn;
        String gksql = "SELECT klasse FROM schueler";
        String gjsql = "SELECT jahrgang FROM schueler";
        ArrayList<String> klassennamen = new ArrayList<String>();
        ArrayList<String> jahrgangnamen = new ArrayList<String>();
        this.gklasse.getItems().clear();
        this.gjahrgang.getItems().clear();
        this.kklassecb.getItems().clear();
        this.kjahrgangcb.getItems().clear();
        try {
            gconn = dbConnection.getConnection();
            st = gconn.createStatement();
            ResultSet rsk = st.executeQuery(gksql);
            ResultSetMetaData rsmdk = rsk.getMetaData();
            int columnsNumberk = rsmdk.getColumnCount();
            while (rsk.next()) {
                i = 1;
                while (i <= columnsNumberk) {
                    if (!klassennamen.contains(rsk.getString(i))) {
                        klassennamen.add(rsk.getString(i));
                        this.gklasse.getItems().add((Object)rsk.getString(i));
                        this.gklasse.getSelectionModel().selectFirst();
                        this.kklassecb.getItems().add((Object)rsk.getString(i));
                        this.kklassecb.getSelectionModel().selectFirst();
                    }
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            System.err.println("Error: " + e);
        }
        try {
            gconn = dbConnection.getConnection();
            st = gconn.createStatement();
            ResultSet rsj = st.executeQuery(gjsql);
            ResultSetMetaData rsmdj = rsj.getMetaData();
            int columnsNumberj = rsmdj.getColumnCount();
            while (rsj.next()) {
                i = 1;
                while (i <= columnsNumberj) {
                    if (!jahrgangnamen.contains(rsj.getString(i))) {
                        jahrgangnamen.add(rsj.getString(i));
                        this.gjahrgang.getItems().add((Object)rsj.getString(i));
                        this.gjahrgang.getSelectionModel().selectFirst();
                        this.kjahrgangcb.getItems().add((Object)rsj.getString(i));
                        this.kjahrgangcb.getSelectionModel().selectFirst();
                    }
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            System.err.println("Error: " + e);
        }
        this.ggroesse.setText("3");
    }

    @FXML
    private void gruppenBildung() {
        String groesse = this.ggroesse.getText();
        String klasse = (String)this.gklasse.getValue();
        String jahrgang = (String)this.gjahrgang.getValue();
        ArrayList<ArrayList<String>> gruppe = new ArrayList<ArrayList<String>>();
        String gsql = "SELECT * FROM schueler WHERE klasse = '" + klasse + "' AND jahrgang = '" + jahrgang + "'";
        try {
            Connection gconn = dbConnection.getConnection();
            Statement st = gconn.createStatement();
            ResultSet rs = st.executeQuery(gsql);
            int gruppencount = 0;
            while (rs.next()) {
                gruppe.add(new ArrayList());
                ((ArrayList)gruppe.get(gruppencount)).add(rs.getString(1));
                ((ArrayList)gruppe.get(gruppencount)).add(rs.getString(2));
                gruppe.get(gruppencount).add(rs.getString(3));
                gruppe.get(gruppencount).add(rs.getString(4));
                gruppe.get(gruppencount).add(rs.getString(5));
                gruppe.get(gruppencount).add(rs.getString(6));
                gruppe.get(gruppencount).add(rs.getString(7));
                ++gruppencount;
            }
            System.out.println("\nNormales Array: " + gruppe + "\n");
            if (this.ggeschlecht.isSelected()) {
                ArrayList<ArrayList<String>> mann = new ArrayList<ArrayList<String>>();
                ArrayList<ArrayList<String>> frau = new ArrayList<ArrayList<String>>();
                ArrayList<Integer> removables = new ArrayList<Integer>();
                mann.addAll(gruppe);
                frau.addAll(gruppe);
                System.out.println("Mann Array: " + mann);
                System.out.println("Frau Array: " + frau);
                int i = 0;
                while (i < gruppe.size()) {
                    String geschlechtArr = gruppe.get(i).get(3).toLowerCase();
                    if (geschlechtArr.compareTo("a") == 22) {
                        removables.add(1);
                    } else {
                        removables.add(0);
                    }
                    ++i;
                }
                i = gruppe.size();
                while (i > 0) {
                    if ((Integer)removables.get(i - 1) == 0) {
                        frau.remove(i - 1);
                    } else if ((Integer)removables.get(i - 1) == 1) {
                        mann.remove(i - 1);
                    }
                    --i;
                }
                Collections.shuffle(mann);
                Collections.shuffle(frau);
                this.gruppenDefinieren(groesse, mann, this.gtextarea);
                this.gruppenDefinieren(groesse, frau, this.gtextarea2);
            } else {
                Collections.shuffle(gruppe);
                this.gruppenDefinieren(groesse, gruppe, this.gtextarea);
            }
        }
        catch (SQLException e) {
            System.err.println("Error: " + e);
        }
    }

    private void gruppenDefinieren(String gruppengroesse, ArrayList<ArrayList<String>> arrList, TextArea ta) {
        if (this.gleistung.isSelected()) {
            System.out.print("Sortieren nach Leistung");
            Collections.sort(arrList, new Comparator<ArrayList<String>>(){

                @Override
                public int compare(ArrayList<String> a, ArrayList<String> b) {
                    Integer intA = Integer.parseInt(a.get(5));
                    Integer intB = Integer.parseInt(b.get(5));
                    return intA.compareTo(intB);
                }
            });
        }
        if (!this.ggeschlecht.isSelected()) {
            this.gtextarea2.setText("");
        }
        String gruppenText = "\n";
        int i = 1;
        int gruppen = 2;
        gruppenText = String.valueOf(gruppenText) + "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 Gruppe 1 \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557\n";
        int j = 0;
        while (j < arrList.size()) {
            if (i <= Integer.parseInt(gruppengroesse)) {
                gruppenText = String.valueOf(gruppenText) + "\u2551             " + arrList.get(j).get(1) + "  " + arrList.get(j).get(2) + "  " + arrList.get(j).get(5) + "\n";
                ++i;
            } else {
                gruppenText = String.valueOf(gruppenText) + "\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 Gruppe " + gruppen + " \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563\n";
                gruppenText = String.valueOf(gruppenText) + "\u2551             " + arrList.get(j).get(1) + "  " + arrList.get(j).get(2) + "  " + arrList.get(j).get(5) + "\n";
                ++gruppen;
                i = 2;
            }
            ++j;
        }
        gruppenText = String.valueOf(gruppenText) + "\u255as\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n";
        ta.setText(gruppenText);
    }
}

